#include "WorldObject.h"

#include <GL/glew.h>
#include <GL/GL.h>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtc/type_ptr.hpp>

logic::WorldObject::WorldObject(
	graphics::Renderable * model,
	const glm::vec3 & position,
	const glm::vec3 & orientation,
	const glm::vec3 scale
	) : m_model(model), m_position(position), m_orientation(orientation), m_scale(scale)
{
	
}


logic::WorldObject::~WorldObject()
{
}

void logic::WorldObject::render(graphics::ShaderProgram * mainProgram) {


	glm::mat4 transformation = glm::mat4(1.0f);

	
	transformation = glm::translate(transformation, m_position);
	transformation = glm::rotate(transformation, m_orientation[0], glm::vec3(1.0f, 0.0f, 0.0f));
	transformation = glm::rotate(transformation, m_orientation[1], glm::vec3(0.0f, 1.0f, 0.0f));
	transformation = glm::rotate(transformation, m_orientation[2], glm::vec3(0.0f, 0.0f, 1.0f));
	transformation = glm::scale(transformation, m_scale);

	GLint worldTransformationLoc = mainProgram->getLocation("WORLD");
	glUniformMatrix4fv(worldTransformationLoc, 1, GL_FALSE, glm::value_ptr(transformation));

	GLint normalTransformationLoc = mainProgram->getLocation("NORMAL");
	glUniformMatrix4fv(normalTransformationLoc, 1, GL_FALSE, glm::value_ptr(glm::transpose(glm::inverse(transformation))));

	m_model->render();

}